function MAPOUT = fixslipsurfaces( MAP, slipsurfacevalue )
% MAPOUT = fixslipsurfaces( MAP, slipsurfacevalue )
% 
% Fixes slip surfaces in model maps. It tries to fix slip surfaces into one
% pixel wide lineaments, along the entire length og the slip surface there
% is always contact between faces ie each slip surface pixel is connected
% to another by pixels directly horizontally or vertically next to it, not
% diagonally.

MAP2 = validateslipsurface4( MAP, slipsurfacevalue );

pixelstoremove = find( xor( MAP == slipsurfacevalue, MAP2) );


MAPOUT = MAP;

for idx = 1 : length( pixelstoremove ),
    MAPOUT( pixelstoremove(idx) ) = nearestnonslipsurface( MAP, pixelstoremove( idx ), slipsurfacevalue );
end